/*   This is RIFFL, the Replacement iffparse.library, a collection of
 *   routines to read IFF files.
 *
 *   Copyright (C) 1997 Kim-Minh Kaplan.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License version 2 as published by the Free Software Foundation.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License in the file named COPYING for more
 *   details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef ALIB_IFF_ILBM_H
#define ALIB_IFF_ILBM_H

#include <libraries/iffparse.h>

#define ID_ILBM		MAKE_ID('I','L','B','M')
#define ID_BMHD		MAKE_ID('B','M','H','D')
#define ID_CMAP		MAKE_ID('C','M','A','P')
#define ID_CAMG		MAKE_ID('C','A','M','G')
#define ID_BODY		MAKE_ID('B','O','D','Y')

enum ILBMMasking {
    ILBMMskNone, ILBMMskHasMask, ILBMMskHasTransparentColor, ILBMMskLasso
};

enum ILBMCompression {
    ILBMCmpNone, ILBMCmpByteRun1
};

struct ILBM_BMHD {
    unsigned short	Width;	/* Raster width in pixels */
    unsigned short	Height;	/* Raster height in pixels */
    short		X;	/* Pixel horizontal position for this image */
    short		Y;	/* Pixel versical position for this image */
    unsigned char	Depth;	/* # of source bitplanes */
    enum ILBMMasking	Masking;
    enum ILBMCompression Compression;
    unsigned short	TransparentColor; /* transparent color number */
    unsigned short	XAspect; /* Pixel aspect, a ratio width : height */
    unsigned short	YAspect;
    short		PageWidth; /* Source page width in pixels */
    short		PageHeight; /* Source page height in pixels */
};

struct ILBM_CMAP {
    unsigned char	Red;
    unsigned char	Green;
    unsigned char	Blue;
};

#endif /* not ALIB_IFF_ILBM_H */
