/*   This is RIFFL, the Replacement iffparse.library, a collection of
 *   routines to read IFF files.
 *
 *   Copyright (C) 1997 Kim-Minh Kaplan.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License version 2 as published by the Free Software Foundation.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License in the file named COPYING for more
 *   details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef IFFPARSE_H
#define IFFPARSE_H
#include <exec/lists.h>

#define MAKE_ID(a,b,c,d)						\
		((unsigned long)(a) << 24 | (unsigned long)(b) << 16	\
		 | (unsigned long)(c) << 8 | (unsigned long)(d))

struct LocalContextItem {
    struct MinNode	lci_Node;
    unsigned long	lci_ID;
    unsigned long	lci_Type;
    unsigned long	lci_Ident;
    /* There are private fields hiding here */
};

struct ContextNode {
    struct MinNode	cn_Node;
    unsigned long	cn_ID;
    unsigned long	cn_Type;
    unsigned long	cn_Size; /* Size of this chunk */
    unsigned long	cn_Scan; /* # of bytes read/written so far */
    /* There are private fields hiding here */
};

/*
 * Structure associated with an active IFF stream.
 * "iff_Stream" is a value used by the client's read/write/seek functions -
 * it will not be accessed by the library itself and can have any value.
 */
struct IFFHandle {
    unsigned long	iff_Stream;
    enum {
	IFFF_FSEEK = 0x4,
	IFFF_RSEEK = 0x8
    }			iff_Flags;
    int			iff_Depth; /* Depth of context stack */
    /* There are private fields hiding here */
};

enum {IFFF_READ, IFFF_WRITE};

struct IFFStreamCmd {
    enum {IFFCMD_INIT,		/* Prepare the stream for a session */
	  IFFCMD_CLEANUP,		/* Terminate stream session */
	  IFFCMD_READ,		/* Read bytes from stream */
	  IFFCMD_WRITE,		/* Write bytes to stream */
	  IFFCMD_SEEK,		/* Seek on stream */
	  IFFCMD_ENTRY,		/* You just entered a new context */
	  IFFCMD_EXIT,		/* Your're about to leave a context */
	  IFFCMD_PURGELCI	/* Purge a LocalContextItem */
    }		sc_Command;	/* Operation to be performed */
    char       *sc_Buf;		/* Pointer to data buffer */
    long	sc_NBytes;	/* Number of bytes to be affected */
};

struct StoredProperty {
    unsigned long	sp_Size;
    unsigned char      *sp_Data;
};

#if 0
/* Not used yet */
struct CollectionItem {
    struct CollectionItem      *ci_Next;
    long			ci_Size;
    unsigned char	       *ci_Data;
};
#endif

enum {
    IFF_RETURN2CLIENT = -12,
    IFFERR_NOHOOK,
    IFFERR_NOTIFF,
    IFFERR_SYNTAX,
    IFFERR_MANGLED,
    IFFERR_SEEK,
    IFFERR_WRITE,
    IFFERR_READ,
    IFFERR_NOMEM,
    IFFERR_NOSCOPE,
    IFFERR_EOC,
    IFFERR_EOF
};

enum {
    IFFSLI_ROOT,
    IFFSLI_TOP,
    IFFSLI_PROP
};

enum {IFFPARSE_SCAN, IFFPARSE_STEP, IFFPARSE_RAWSTEP};

#define IFFSIZE_UNKNOWN		-1L

#define ID_FORM			MAKE_ID('F','O','R','M')
#define ID_LIST			MAKE_ID('L','I','S','T')
#define ID_PROP			MAKE_ID('P','R','O','P')
#define ID_CAT			MAKE_ID('C','A','T',' ')

#define IFFLCI_ENTRYHANDLER	MAKE_ID('e','n','h','d')
#define IFFLCI_EXITHANDLER	MAKE_ID('e','x','h','d')
#define IFFLCI_PROP		MAKE_ID('p','r','o','p')

#endif /* not IFFPARSE_H */
