/*   This is RIFFL, the Replacement iffparse.library, a collection of
 *   routines to read IFF files.
 *
 *   Copyright (C) 1997 Kim-Minh Kaplan.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License version 2 as published by the Free Software Foundation.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License in the file named COPYING for more
 *   details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PROTO_IFFPARSE_H
#define PROTO_IFFPARSE_H

struct LocalContextItem;
struct IFFHandle;
struct ContextNode;
struct Hook;

extern char *IDtoStr(long, char *);
extern int GoodID(unsigned long);
extern int GoodType(unsigned long);
extern struct LocalContextItem *AllocLocalItem(unsigned long, unsigned long,
					       unsigned long, unsigned long);
extern void FreeLocalItem(struct LocalContextItem *);
extern unsigned char *LocalItemData(struct LocalContextItem *);
extern struct LocalContextItem *FindLocalItem(struct IFFHandle *,
					      unsigned long, unsigned long,
					      unsigned long);
extern struct ContextNode *CurrentChunk(struct IFFHandle *);
extern struct ContextNode *FindPropContext(struct IFFHandle *);
extern struct ContextNode *ParentChunk(struct ContextNode *);
extern void StoreItemInContext(struct IFFHandle *, struct LocalContextItem *,
			       struct ContextNode *);
extern int StoreLocalItem(struct IFFHandle *, struct LocalContextItem *, int);
extern int EntryHandler(struct IFFHandle *, unsigned long, unsigned long,
			int, struct Hook *, void *);
extern int ExitHandler(struct IFFHandle *, unsigned long, unsigned long,
			int, struct Hook *, void *);
extern int StopChunk(struct IFFHandle *, unsigned long, unsigned long);
extern int StopOnExit(struct IFFHandle *, unsigned long, unsigned long);
extern int PropChunk(struct IFFHandle *, unsigned long, unsigned long);
extern struct StoredProperty *FindProp(struct IFFHandle *, unsigned long,
				       unsigned long);
extern long ReadChunkBytes(struct IFFHandle *, unsigned char *, long);
extern long ReadChunkRecords(struct IFFHandle *, unsigned char *, long, long);
extern long WriteChunkBytes(struct IFFHandle *, unsigned char *, long);
extern struct IFFHandle *AllocIFF(void);
extern void InitIFF(struct IFFHandle *, long, struct Hook *);
extern int OpenIFF(struct IFFHandle *, long);
extern void CloseIFF(struct IFFHandle *);
extern void FreeIFF(struct IFFHandle *);
extern int PushChunk(struct IFFHandle *, unsigned long, unsigned long, long);
extern int PopChunk(struct IFFHandle *);
extern int ParseIFF(struct IFFHandle *, int);

#endif /* not PROTO_IFFPARSE_H */
