/*   This is RIFFL, the Replacement iffparse.library, a collection of
 *   routines to read IFF files.
 *
 *   Copyright (C) 1997 Kim-Minh Kaplan.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License version 2 as published by the Free Software Foundation.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License in the file named COPYING for more
 *   details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libraries/iffparse.h>
#include <utility/hooks.h>
#include <proto/iffparse.h>
#include <proto/alib.h>

#include <stdio.h>

static long
StreamHandler(struct Hook *hook, struct IFFHandle *iff,
		struct IFFStreamCmd *actionpkt)
{
    FILE *stream = (FILE *)iff->iff_Stream;
    long nbytes = actionpkt->sc_NBytes;
    char *buf = actionpkt->sc_Buf;
    long error = 0;
    switch (actionpkt->sc_Command) {
    case IFFCMD_READ:
	error = fread(buf, nbytes, 1, stream) != 1;
	break;
    case IFFCMD_WRITE:
	error = fwrite(buf, nbytes, 1, stream) != 1;
	break;
    case IFFCMD_SEEK:
	error = fseek(stream, nbytes, SEEK_CUR) != 0;
	break;
    case IFFCMD_INIT:
	error = 0;
	break;
    case IFFCMD_CLEANUP:
	error = 0;
	break;
    default:
	error = IFFERR_NOHOOK;
    }
    return error;
}

static struct Hook streamHook = {
	{ NULL }, 0, StreamHandler, NULL
};

void
InitIFFasFILE(struct IFFHandle *iff)
{
    InitIFF(iff, 0, &streamHook);
}

