/*   This is RIFFL, the Replacement iffparse.library, a collection of
 *   routines to read IFF files.
 *
 *   Copyright (C) 1997 Kim-Minh Kaplan.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License version 2 as published by the Free Software Foundation.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License in the file named COPYING for more
 *   details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <alib/iff-ilbm.h>
#include <proto/alib.h>
#include <proto/iffparse.h>

#include <string.h>

int
ILBMDecodeByteRun1(struct IFFHandle *iff, unsigned char *p, long n)
{
    int error = 0;
    signed char cmd;
    while (error == 0 && n > 0)
	if (ReadChunkBytes(iff, &cmd, 1) == 1)
	    if (cmd < -128 || cmd > 127)
		error = IFFERR_MANGLED;
	    else if (cmd >= 0)	/* Litteral run */
		if (ReadChunkBytes(iff, p, cmd + 1) == cmd + 1) {
		    p += cmd + 1;
		    n -= cmd + 1;
		}
		else
		    error = IFFERR_READ;
	    else if (cmd > -128) /* Repeat run */
		if (ReadChunkBytes(iff, p, 1) == 1) {
		    memset(p + 1, *p, -cmd);
		    p += -cmd + 1;
		    n -= -cmd + 1;
		}
		else
		    error = IFFERR_READ;
	    else /* cmd == -128 */
		/* NOP */;
	else
	    error = IFFERR_READ;
    return error;
}

void
ILBMRowToChunky(const unsigned char *row, unsigned char depth, long byte_per_row,
		unsigned char *out, unsigned int width)
{
    const int byte_per_pixel = (depth + 7) / 8;
    int x;
    memset(out, 0, width * byte_per_pixel);
    for (x = 0; x < width; x++) {
	int byte = x / 8;
	unsigned char mask = 0x80 >> (x % 8);
	int n;
	for (n = 0; n < depth; n++)
	    if (row[n * byte_per_row + byte] & mask)
		out[x * byte_per_pixel + n / 8] |= 1 << (n % 8);
    }
}
