/*   This is RIFFL, the Replacement iffparse.library, a collection of
 *   routines to read IFF files.
 *
 *   Copyright (C) 1997 Kim-Minh Kaplan.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License version 2 as published by the Free Software Foundation.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License in the file named COPYING for more
 *   details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <alib/iff-ilbm.h>
#include <proto/alib.h>
#include <proto/iffparse.h>

/* If `iff' is 0, just count the number of bytes this line would
   get encoded to and return it.  Otherwise, write the encoded line to
   `iff' and return an error code. */
long
ILBMEncodeByteRun1(struct IFFHandle *iff, const unsigned char *p, long n)
{
    unsigned char cmd;
    long error = 0, count = 0, idx = 0;
    while (error == 0 && idx < n)
	/* Find out if this run is a repeat or a litteral */
	if (idx + 1 == n) {	/* single litteral */
	    cmd = 0;
	    if (iff == 0
		|| (WriteChunkBytes(iff, &cmd, 1) == 1
		    && WriteChunkBytes(iff, (unsigned char *)&p[idx], 1) == 1))
		count += 2;
	    else
		error = IFFERR_WRITE;
	    idx++;
	}
	else if (p[idx] == p[idx + 1]) { /* repeat */
	    long run;
	    /* find length of run */
	    for (run = 2; idx + run < n && run < 128; run++)
		if (p[idx] != p[idx + run])
		    break;
	    cmd = 1 - run;
	    if (iff == 0
		|| (WriteChunkBytes(iff, &cmd, 1) == 1
		    && WriteChunkBytes(iff, (unsigned char *)&p[idx], 1) == 1))
		count += 2;
	    else
		error = IFFERR_WRITE;
	    idx += run;
	}
	else {		/* literal */
	    int run;
	    for (run = 2; idx + run < n && run < 128; run++)
		if (p[idx + run - 1] == p[idx + run]) {
		    /* If the repeat run is only 2 bytes long, merge
                       it here. Note that we already have found a 2
                       repeat run.  Just see if there is another one*/
		    if (idx + run + 1 >= n
			|| p[idx + run] == p[idx + run + 1]) {
			run--;
			break;
		    }
		}
	    cmd = run - 1;
	    if (iff == 0
		|| (WriteChunkBytes(iff, &cmd, 1) == 1
		    && WriteChunkBytes(iff, (unsigned char *)&p[idx], run)
		    == run))
		count += run + 1;
	    else
		error = IFFERR_WRITE;
	    idx += run;
	}
    return iff == 0 ? count : error;
}

void
ILBMChunkyToRow(const unsigned char *line, unsigned int width, int bpp,
		unsigned char plane, unsigned char *out)
{
    unsigned char mask = 1UL << (plane % 8);
    int off = plane / 8;
    int x;
    for (x = 0; x < width; x++) {
	unsigned char bit = 0x80U >> (x % 8);
	if (line[x * bpp + off] & mask)
	    out[x / 8] |= bit;
	else
	    out[x / 8] &= ~bit;
    }
}
