/*   This is RIFFL, the Replacement iffparse.library, a collection of
 *   routines to read IFF files.
 *
 *   Copyright (C) 1997 Kim-Minh Kaplan.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License version 2 as published by the Free Software Foundation.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License in the file named COPYING for more
 *   details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <exec/lists.h>
#include <proto/exec.h>

static void
AdjustAdjacent(struct Node *node)
{
    node->ln_Succ->ln_Pred = node;
    node->ln_Pred->ln_Succ = node;
}

void
AddHead(struct List *list, struct Node *node)
{
    node->ln_Succ = list->lh_Head;
    node->ln_Pred = (struct Node *)list;
    AdjustAdjacent(node);
}

void
AddTail(struct List *list, struct Node *node)
{
    node->ln_Succ = (struct Node *)&list->lh_Tail;
    node->ln_Pred = list->lh_TailPred;
    AdjustAdjacent(node);
}

void
Insert(struct List *list, struct Node *node, struct Node *pred)
{
    if (pred == 0 || pred == (struct Node *)list)
	AddHead(list, node);
    else if (pred == (struct Node *)list->lh_Tail)
	AddTail(list, node);
    else {
	node->ln_Pred = pred;
	node->ln_Succ = pred->ln_Succ;
	AdjustAdjacent(node);
    }
}

void
Remove(struct Node *node)
{
    node->ln_Pred->ln_Succ = node->ln_Succ;
    node->ln_Succ->ln_Pred = node->ln_Pred;
}

struct Node *
RemHead(struct List *list)
{
    if (list->lh_TailPred != (struct Node *)list) {
	struct Node *node = list->lh_Head;
	list->lh_Head = node->ln_Succ;
	node->ln_Succ->ln_Pred = node->ln_Pred;
	return node;
    }
    else
	return 0;
}

struct Node *
RemTail(struct List *list)
{
    if (list->lh_TailPred != (struct Node *)list) {
	struct Node *node = list->lh_TailPred;
	list->lh_TailPred = node->ln_Pred;
	node->ln_Pred->ln_Succ = node->ln_Succ;
	return node;
    }
    else
	return 0;
}
